<?php
require_once( TEMPLATEPATH.'/lib/init.php' );

// Child theme (do not remove)
define( 'CHILD_THEME_NAME', 'Transchild Theme' );
define( 'CHILD_THEME_URL', 'http://www.joshstauffer.com/' );

// Add support for custom background
if ( function_exists( 'add_custom_background' ) ) {
	add_custom_background();
}

// Add new image sizes
add_image_size( 'slider', 600, 300, TRUE );

// Add widgeted footer section
function transchild_footer_widgets() {
	require( CHILD_DIR.'/footer-widgets.php' );
}
add_action( 'genesis_before_footer', 'transchild_footer_widgets' );

// Force layout on homepage
function transchild_home_layout( $opt ) {
	if ( is_home() )
	$opt = 'content-sidebar';
	return $opt;
}
add_filter( 'genesis_pre_get_option_site_layout', 'transchild_home_layout' );

// Register widget areas
genesis_register_sidebar( array(
	'id' => 'homepage',
	'name' => __( 'Homepage', 'transchild' ),
	'description' => __( 'This is the featured column of the homepage.', 'transchild' ),
) );
genesis_register_sidebar( array(
	'id' => 'footer-1',
	'name' => __( 'Footer #1', 'transchild' ),
	'description' => __( 'This is the first column of the footer section.', 'transchild' ),
) );
genesis_register_sidebar( array(
	'id' => 'footer-2',
	'name' => __( 'Footer #2', 'transchild' ),
	'description' => __( 'This is the second column of the footer section.', 'transchild' ),
) );
genesis_register_sidebar( array(
	'id' => 'footer-3',
	'name' => __( 'Footer #3', 'transchild' ),
	'description' => __( 'This is the third column of the footer section.', 'transchild' ),
) );

// 
function transchild_init() {
	wp_enqueue_script( 'transchild-slider-script', CHILD_URL . '/lib/js/transchild-slider.js', array( 'jquery' ) );
	wp_enqueue_script( 'transchild-common-script', CHILD_URL . '/lib/js/transchild-common.js', array( 'jquery' ) );
	wp_enqueue_style( 'transchild-slider-styles', CHILD_URL . '/slider.css' );
	wp_enqueue_style( 'transchild-slider-custom-styles', CHILD_URL . '/slider-custom.css' );
}
add_action( 'init', 'transchild_init' );

// Adds a wrap around all except header
function transchild_after_header() {
	echo '<div id="tcwrap">';
}
add_action( 'genesis_after_header', 'transchild_after_header', 5 );

function transchild_after_footer() {
	echo '</div><!-- end #tcwrap -->';
}
add_action( 'genesis_after_footer', 'transchild_after_footer' );

// Modify credits section
function transchild_footer_creds_text( $creds ) {
	$creds = __( 'Copyright', 'transchild' ) . ' [footer_copyright] [footer_childtheme_link] on <a href="http://www.joshstauffer.com/go/genesis/" title="Genesis Framework">Genesis Framework</a> &middot; [footer_wordpress_link] &middot; [footer_loginout]';
	return $creds;
}
add_filter( 'genesis_footer_creds_text', 'transchild_footer_creds_text' );